// Get API Key
let STRIPE_PUBLISHABLE_KEY = document.currentScript.getAttribute('STRIPE_PUBLISHABLE_KEY');
let STRIPE_NAME = document.currentScript.getAttribute('STRIPE_NAME');
let STRIPE_EMAIL = document.currentScript.getAttribute('STRIPE_EMAIL');
let STRIPE_COUNTRY = document.currentScript.getAttribute('STRIPE_COUNTRY');
let STRIPE_PRICE_ID = document.currentScript.getAttribute('STRIPE_PRICE_ID');
let STRIPE_ASR_VPN_PRICE_ID = document.currentScript.getAttribute('STRIPE_ASR_VPN_PRICE_ID');

// Create an instance of the Stripe object and set your publishable API key
const stripe = Stripe(STRIPE_PUBLISHABLE_KEY);

// Select subscription form element
const subscrFrm = document.querySelector("#subscrFrm");

// Attach an event handler to subscription form
subscrFrm.addEventListener("submit", paymentProcess);

const items = [{ id: "asr_with_avpn", price: 100 }];
//initialize();
// Fetches a payment intent and captures the client secret

let cardElement;
let elements;
let product_price_id;


console.log("Product Price ID 1", product_price_id);

// let elements = stripe.elements();
var style = {
    base: {
        lineHeight: "30px",
        fontSize: "16px",
        border: "1px solid #ced4da",
    }
};

// let elements = stripe.elements();
// var style = {
//     base: {
//         lineHeight: "30px",
//         fontSize: "16px",
//         border: "1px solid #ced4da",
//     }
// };
// let cardElement = elements.create('card', { style: style });
// cardElement.mount('#card-element');

// cardElement.on('change', function (event) {
//     displayError(event);
// });


function displayError(event) {
    if (event.error) {
        showMessage(event.error.message);
    }
}

product_price_id = STRIPE_PRICE_ID;
console.log("Product Price ID 2", product_price_id);
handleSubscrSubmit(product_price_id);
function handleSubscrSubmit(p_price_id) {
    //e.preventDefault();
    setLoading(true);

	let tr_aid = document.getElementById("tr_aid").innerText;
    let tr_sid = document.getElementById("tr_sid").innerText;
    let tr_tid = document.getElementById("tr_tid").innerText;
    let tr_cid = document.getElementById("tr_cid").innerText;
    let tr_iid = document.getElementById("tr_iid").innerText;

    //window.alert(JSON.stringify({ request_type:'create_customer_subscription',name: STRIPE_NAME, email: STRIPE_EMAIL, country: STRIPE_COUNTRY, price_id: p_price_id, traid: tr_aid, trsid: tr_sid, trtid: tr_tid, trcid: tr_cid }));
	
    // Post the subscription info to the server-side script
    fetch("payment_init.php", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ request_type:'create_customer_subscription',name: STRIPE_NAME, email: STRIPE_EMAIL, country: STRIPE_COUNTRY, price_id: p_price_id, traid: tr_aid, trsid: tr_sid, trtid: tr_tid, trcid: tr_cid, triid: tr_iid }),
    })
    .then(response => response.json())
    .then(data => {
        if (data.subscriptionId && data.clientSecret) {
            initialize(data.subscriptionId, data.clientSecret, data.customerId);
        } else {
            showMessage(data.error);
        }
		
        setLoading(false);
    })
    .catch(console.error);
}


let customer_id;
let subscription_id;
async function initialize(subscriptionId, clientSecret, customerId) {
        // const { clientSecret } = await fetch("create2.php", {
        //     method: "POST",
        //     headers: { "Content-Type": "application/json" },
        //     body: JSON.stringify({ items }),
        // }).then((r) => r.json());
        
        const options = {
          clientSecret: clientSecret
        };
        
        const appearance = {
          labels: 'floating',
        };


        elements = stripe.elements({clientSecret, appearance});
        //console.log(elements);
        const paymentElementOptions = {
            layout: "tabs",
            fields: {
                billingDetails: {
                    address: {
                        country: 'auto',
                        postalCode: 'auto'
                    }
                }
            },
            terms: {
                card: 'never'
            },
            wallets: {
                applePay: 'auto',
                googlePay: 'auto'
            }
        };
        
        
        
        cardElement = elements.create('payment', paymentElementOptions);
        //cardElement = elements.create('card');
        cardElement.mount('#card-element');
        
        cardElement.on('change', function (event) {
            displayError(event);
        });
        
        customer_id = customerId;
        subscription_id = subscriptionId;
        console.log("Product Price ID 3", product_price_id);
}

async function paymentProcess(e){
    e.preventDefault();
    setLoading(true);
    setProcessing(true);
	
    let customer_name = document.getElementById("name").value;
    let customer_email = document.getElementById("email").value;
    // let customer_country = document.getElementById("country").value;
    // let customer_zipcode = document.getElementById("zipcode").value;
    
    fetch("payment_init.php", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ request_type:'update_customer_info',name: customer_name, email: customer_email, customer_id: customer_id }),
    })
    .then(response => response.json())
    .then(data => {
        console.log("Customer", data);
    })
    .catch(console.error);
    
    
    
    let thank_you_page = "https://advancedsystemrepair.com/thank-you-sp-j-n.php";
    if(product_price_id == STRIPE_ASR_VPN_PRICE_ID){
        thank_you_page = "https://advancedsystemrepair.com/thank-you-sp-apg-j-n.php";
    }
    
	const { error } = await stripe.confirmPayment({
        elements,
        confirmParams: {
            // Make sure to change this to your payment completion page
            return_url: thank_you_page,
        },
        
    });

    // This point will only be reached if there is an immediate error when
    // confirming the payment. Otherwise, your customer will be redirected to
    // your `return_url`. For some payment methods like iDEAL, your customer will
    // be redirected to an intermediate site first to authorize the payment, then
    // redirected to the `return_url`.
    if (error.type === "card_error" || error.type === "validation_error") {
        showMessage(error.message);
    } else {
        showMessage("An unexpected error occurred.");
    }

    setLoading(false);
}

console.log("Product Price ID 5", product_price_id);

$("#avpn_additional").click(function(){
    //alert("ok");
    if($(this).is(":checked")){
        product_price_id = document.getElementById("asr_avpn_product_price_id").value;
    }
    else{
        product_price_id = document.getElementById("asr_product_price_id").value;
    }
    handleSubscrSubmit(product_price_id);
    
    console.log("Product Price ID 6", product_price_id);
    
    
});

// Display message
function showMessage(messageText) {
    const messageContainer = document.querySelector("#paymentResponse");
	
    messageContainer.classList.remove("hidden");
    messageContainer.textContent = messageText;
	
    setTimeout(function () {
        messageContainer.classList.add("hidden");
        messageText.textContent = "";
    }, 5000);
}


// Show a spinner on payment submission
function setLoading(isLoading) {
    if (isLoading) {
        // Disable the button and show a spinner
        document.querySelector("#submitBtn").disabled = true;
        document.querySelector("#spinner").classList.remove("hidden");
        document.querySelector("#buttonText").classList.add("hidden");
    } else {
        // Enable the button and hide spinner
        document.querySelector("#submitBtn").disabled = false;
        document.querySelector("#spinner").classList.add("hidden");
        document.querySelector("#buttonText").classList.remove("hidden");
    }
}

// Show a spinner on payment form processing
function setProcessing(isProcessing) {
    if (isProcessing) {
        //subscrFrm.classList.add("hidden");
        document.querySelector("#frmProcess").classList.remove("hidden");
    } else {
        //subscrFrm.classList.remove("hidden");
        document.querySelector("#frmProcess").classList.add("hidden");
    }
}